<?php
require_once __DIR__ . '/../lib/auth.php'; require_once __DIR__ . '/../lib/helpers.php';
require_login(); require_admin(); $pdo=db();

// Handle create group/item
if($_SERVER['REQUEST_METHOD']==='POST'){ csrf_check();
  if(isset($_POST['new_group'])){
    $pdo->prepare("INSERT INTO checklist_groups(name,sort_order) VALUES (?,?)")->execute([trim($_POST['name']), (int)$_POST['sort_order']]);
  } elseif(isset($_POST['new_item'])){
    $pdo->prepare("INSERT INTO checklist_items(group_id,item_key,label,weight,required,sort_order) VALUES (?,?,?,?,?,?)")
        ->execute([(int)$_POST['group_id'], trim($_POST['item_key']), trim($_POST['label']), (float)$_POST['weight'], isset($_POST['required'])?1:0, (int)$_POST['sort_order']]);
  }
  header('Location: /admin/checklist.php'); exit;
}

$groups=$pdo->query("SELECT * FROM checklist_groups ORDER BY sort_order,id")->fetchAll();
$items=$pdo->query("SELECT * FROM checklist_items ORDER BY group_id, sort_order, id")->fetchAll();
$itemsByGroup=[]; foreach($groups as $g){ $itemsByGroup[$g['id']]=[]; }
foreach($items as $it){ $itemsByGroup[$it['group_id']][]=$it; }
?>
<!doctype html><html lang="ar" dir="rtl"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>إدارة بنود الفحص</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="/public/assets/app.css" rel="stylesheet">
</head><body>
<?php include __DIR__.'/../public/layout_nav.php'; ?>
<div class="container py-4">
  <h2 class="mb-3">إدارة بنود الفحص</h2>

  <div class="row g-3">
    <div class="col-md-4">
      <div class="card shadow rounded-4">
        <div class="card-body">
          <h5 class="mb-3">إضافة مجموعة</h5>
          <form method="post" class="vstack gap-2">
            <input type="hidden" name="csrf" value="<?=e(csrf_token())?>">
            <input type="hidden" name="new_group" value="1">
            <input class="form-control" name="name" placeholder="اسم المجموعة" required>
            <input class="form-control" name="sort_order" type="number" value="0">
            <button class="btn btn-primary">إضافة</button>
          </form>
        </div>
      </div>
      <div class="card shadow rounded-4 mt-3">
        <div class="card-body">
          <h5 class="mb-3">إضافة عنصر</h5>
          <form method="post" class="vstack gap-2">
            <input type="hidden" name="csrf" value="<?=e(csrf_token())?>">
            <input type="hidden" name="new_item" value="1">
            <label class="form-label">المجموعة</label>
            <select class="form-select" name="group_id">
              <?php foreach($groups as $g): ?><option value="<?=$g['id']?>"><?=e($g['name'])?></option><?php endforeach; ?>
            </select>
            <input class="form-control" name="item_key" placeholder="مفتاح فريد (engine_oil...)" required>
            <input class="form-control" name="label" placeholder="الاسم الظاهر" required>
            <input class="form-control" name="weight" type="number" step="0.1" value="1.0">
            <div class="form-check"><input class="form-check-input" type="checkbox" name="required" id="req"><label for="req" class="form-check-label">مطلوب</label></div>
            <input class="form-control" name="sort_order" type="number" value="0">
            <button class="btn btn-primary">إضافة</button>
          </form>
        </div>
      </div>
    </div>
    <div class="col-md-8">
      <?php foreach($groups as $g): $gitems=$itemsByGroup[$g['id']]??[]; ?>
      <div class="card shadow rounded-4 mb-3">
        <div class="card-body">
          <h5 class="mb-3"><?=e($g['name'])?></h5>
          <div class="table-responsive">
            <table class="table table-sm align-middle">
              <thead><tr><th>#</th><th>المفتاح</th><th>العنصر</th><th>الوزن</th><th>مطلوب</th></tr></thead>
              <tbody>
                <?php foreach($gitems as $it): ?>
                <tr>
                  <td><?=$it['id']?></td>
                  <td><code><?=$it['item_key']?></code></td>
                  <td><?=e($it['label'])?></td>
                  <td><?=e($it['weight'])?></td>
                  <td><?=$it['required']?'نعم':'لا'?></td>
                </tr>
                <?php endforeach; if(!$gitems): ?><tr><td colspan="5" class="text-muted text-center">لا عناصر</td></tr><?php endif; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
      <?php endforeach; ?>
    </div>
  </div>
</div>
</body></html>
