<?php
require_once __DIR__ . '/../lib/auth.php'; require_once __DIR__ . '/../lib/helpers.php';
require_login(); require_admin(); $pdo=db();
$err=''; $ok='';
if($_SERVER['REQUEST_METHOD']==='POST'){ csrf_check();
  $name=trim($_POST['name']??''); $email=trim($_POST['email']??''); $role=$_POST['role']??'inspector'; $pass=$_POST['password']??'';
  if($name===''||$email===''||$pass===''){ $err='كل الحقول مطلوبة'; }
  else{
    try{
      $pdo->prepare("INSERT INTO users(name,email,password,role) VALUES (?,?,?,?)")->execute([$name,$email,password_hash($pass,PASSWORD_DEFAULT),$role]);
      $ok='تمت إضافة المستخدم';
    } catch(Exception $e){ $err='خطأ: '.$e->getMessage(); }
  }
}
$users=$pdo->query("SELECT id,name,email,role,created_at FROM users ORDER BY id DESC")->fetchAll();
?>
<!doctype html><html lang="ar" dir="rtl"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>المستخدمون</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="/public/assets/app.css" rel="stylesheet">
</head><body>
<?php include __DIR__.'/../public/layout_nav.php'; ?>
<div class="container py-4">
  <h2 class="mb-3">المستخدمون</h2>
  <?php if($err): ?><div class="alert alert-danger"><?=$err?></div><?php endif; ?>
  <?php if($ok): ?><div class="alert alert-success"><?=$ok?></div><?php endif; ?>
  <div class="card shadow rounded-4 mb-3">
    <div class="card-body">
      <form class="row g-3" method="post">
        <input type="hidden" name="csrf" value="<?=e(csrf_token())?>">
        <div class="col-md-3"><label class="form-label">الاسم</label><input class="form-control" name="name" required></div>
        <div class="col-md-3"><label class="form-label">البريد</label><input class="form-control" name="email" type="email" required></div>
        <div class="col-md-2"><label class="form-label">الدور</label>
          <select class="form-select" name="role"><option value="inspector">Inspector</option><option value="viewer">Viewer</option><option value="admin">Admin</option></select>
        </div>
        <div class="col-md-3"><label class="form-label">كلمة المرور</label><input class="form-control" name="password" type="text" required></div>
        <div class="col-md-1 d-flex align-items-end"><button class="btn btn-primary w-100">إضافة</button></div>
      </form>
    </div>
  </div>
  <div class="card shadow rounded-4">
    <div class="card-body">
      <div class="table-responsive">
        <table class="table">
          <thead><tr><th>#</th><th>الاسم</th><th>البريد</th><th>الدور</th><th>أُنشئ</th></tr></thead>
          <tbody>
            <?php foreach($users as $u): ?>
            <tr><td><?=$u['id']?></td><td><?=e($u['name'])?></td><td><?=e($u['email'])?></td><td><span class="badge text-bg-secondary"><?=e($u['role'])?></span></td><td><?=e($u['created_at'])?></td></tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
</body></html>
