// Live weighted score and counters
(function(){
  const radios = document.querySelectorAll('.score-radio');
  const bar = document.getElementById('scoreBar');
  const ring = document.getElementById('scoreRing');
  const scoreText = document.getElementById('scoreText');
  const cGood = document.getElementById('countGood');
  const cFair = document.getElementById('countFair');
  const cPoor = document.getElementById('countPoor');
  const cNA = document.getElementById('countNA');

  function compute(){
    let sumWeight = 0, sumEarned = 0;
    let good=0, fair=0, poor=0, na=0;
    const groups = {};
    radios.forEach(r=>{
      const name=r.name; if(!groups[name]) groups[name]=null;
      if(r.checked) groups[name]=r;
    });
    Object.values(groups).forEach(r=>{
      if(!r){ na++; return; }
      const weight=parseFloat(r.getAttribute('data-weight')||'1');
      const val=r.value;
      if(val==='na'){ na++; return; }
      sumWeight += weight;
      if(val==='good'){ sumEarned += weight; good++; }
      else if(val==='fair'){ sumEarned += weight*0.5; fair++; }
      else if(val==='poor'){ poor++; }
    });
    const score = sumWeight>0 ? Math.round((sumEarned/sumWeight)*100) : 0;

    // UI
    bar.style.width = score + '%';
    bar.classList.remove('bg-danger','bg-warning','bg-success');
    if(score>=85) bar.classList.add('bg-success');
    else if(score>=70) bar.classList.add('bg-warning');
    else bar.classList.add('bg-danger');
    ring.style.background = `conic-gradient(var(--primary) 0% ${score}%, #e9ecef ${score}% 100%)`;
    scoreText.textContent = score + '%';
    cGood.textContent = good;
    cFair.textContent = fair;
    cPoor.textContent = poor;
    cNA.textContent = na;
  }
  radios.forEach(r=>r.addEventListener('change', compute));
  compute();
})();
