<?php
require_once __DIR__ . '/../lib/auth.php';
require_once __DIR__ . '/../lib/helpers.php';
require_login();
$pdo=db();
$stats=[
  'cars'=>(int)$pdo->query("SELECT COUNT(*) FROM cars")->fetchColumn(),
  'inspections'=>(int)$pdo->query("SELECT COUNT(*) FROM inspections")->fetchColumn(),
  'pass'=>(int)$pdo->query("SELECT COUNT(*) FROM inspections WHERE status='pass'")->fetchColumn(),
  'fail'=>(int)$pdo->query("SELECT COUNT(*) FROM inspections WHERE status='fail'")->fetchColumn(),
];
$recent=$pdo->query("SELECT i.id, i.overall_score, i.status, i.inspected_at, c.plate_number, c.model FROM inspections i JOIN cars c ON c.id=i.car_id ORDER BY i.inspected_at DESC LIMIT 10")->fetchAll();
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>لوحة التحكم</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="./assets/app.css" rel="stylesheet">
</head>
<body>
<?php include __DIR__.'/layout_nav.php'; ?>
<div class="container py-4">
  <div class="row g-3">
    <div class="col-6 col-md-3"><div class="card metric"><div class="card-body"><div class="title">السيارات</div><div class="value"><?=$stats['cars']?></div></div></div></div>
    <div class="col-6 col-md-3"><div class="card metric"><div class="card-body"><div class="title">التقارير</div><div class="value"><?=$stats['inspections']?></div></div></div></div>
    <div class="col-6 col-md-3"><div class="card metric"><div class="card-body"><div class="title">ناجح</div><div class="value text-success"><?=$stats['pass']?></div></div></div></div>
    <div class="col-6 col-md-3"><div class="card metric"><div class="card-body"><div class="title">راسب</div><div class="value text-danger"><?=$stats['fail']?></div></div></div></div>
  </div>

  <div class="card shadow rounded-4 mt-4">
    <div class="card-body">
      <div class="d-flex justify-content-between align-items-center mb-2">
        <h5 class="mb-0">آخر التقارير</h5>
        <a class="btn btn-sm btn-outline-secondary" href="/public/inspections.php">عرض الكل</a>
      </div>
      <div class="table-responsive">
        <table class="table align-middle">
          <thead><tr><th>التاريخ</th><th>اللوحة</th><th>الموديل</th><th>النتيجة</th><th>الحالة</th><th></th></tr></thead>
          <tbody>
          <?php foreach($recent as $r): ?>
            <tr>
              <td><?=e(date('Y-m-d H:i',strtotime($r['inspected_at'])))?></td>
              <td><?=e($r['plate_number'])?></td>
              <td><?=e($r['model'])?></td>
              <td>
                <div class="progress" style="height:10px">
                  <div class="progress-bar <?=color_class((int)$r['overall_score'])?>" style="width: <?=$r['overall_score']?>%"></div>
                </div>
              </td>
              <td><span class="badge <?=($r['status']=='pass'?'text-bg-success':'text-bg-danger')?>"><?=($r['status']=='pass'?'ناجح':'راسب')?></span></td>
              <td><a class="btn btn-sm btn-outline-primary" href="/public/inspection_view.php?id=<?=$r['id']?>">فتح</a></td>
            </tr>
          <?php endforeach; if(empty($recent)): ?>
            <tr><td colspan="6" class="text-center text-muted">لا توجد تقارير بعد</td></tr>
          <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
</body>
</html>
