<?php
require_once __DIR__ . '/../lib/auth.php';
require_once __DIR__ . '/../lib/helpers.php';

$pdo = db();
if ((int)$pdo->query("SELECT COUNT(*) FROM users")->fetchColumn()===0){
  $pdo->prepare("INSERT INTO users(name,email,password,role) VALUES (?,?,?, 'admin')")
      ->execute(['Hazal Admin','admin@hazal.ae',password_hash('Admin@12345', PASSWORD_DEFAULT)]);
}

$error='';
if($_SERVER['REQUEST_METHOD']==='POST'){
  csrf_check();
  if(attempt_login(trim($_POST['email']??''), $_POST['password']??'')){
    redirect('/public/dashboard.php');
  } else $error='بيانات الدخول غير صحيحة';
}
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>دخول - نظام فحص هازال v2</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="./assets/app.css" rel="stylesheet">
</head>
<body class="bg-body-tertiary">
<div class="container py-5">
  <div class="row justify-content-center">
    <div class="col-md-5">
      <div class="card shadow rounded-4 border-0">
        <div class="card-body p-4">
          <h1 class="h4 text-center mb-2">Hazal Inspection v2</h1>
          <p class="text-center text-muted mb-4">واجهة فخمة + نظام نقاط ووزن ذكي</p>
          <?php if($error): ?><div class="alert alert-danger"><?=$error?></div><?php endif; ?>
          <form method="post" class="vstack gap-3">
            <input type="hidden" name="csrf" value="<?=e(csrf_token())?>">
            <div>
              <label class="form-label">البريد الإلكتروني</label>
              <input class="form-control form-control-lg" name="email" type="email" required>
            </div>
            <div>
              <label class="form-label">كلمة المرور</label>
              <input class="form-control form-control-lg" name="password" type="password" required>
              <div class="form-text">افتراضي: admin@hazal.ae / Admin@12345</div>
            </div>
            <button class="btn btn-primary btn-lg w-100">دخول</button>
          </form>
        </div>
      </div>
      <p class="text-center small text-muted mt-3">© <?=date('Y')?> Hazal Rent a Car</p>
    </div>
  </div>
</div>
</body>
</html>
