<?php
require_once __DIR__ . '/../lib/auth.php';
require_once __DIR__ . '/../lib/helpers.php';
require_login();
$pdo=db();
$id=(int)($_GET['id']??0);
$stmt=$pdo->prepare("SELECT i.*, c.plate_number,c.make,c.model,c.year,c.vin,c.mileage,c.color, u.name inspector FROM inspections i JOIN cars c ON c.id=i.car_id JOIN users u ON u.id=i.user_id WHERE i.id=?");
$stmt->execute([$id]); $ins=$stmt->fetch();
if(!$ins){ http_response_code(404); die('Not found'); }
$items=$pdo->prepare("SELECT * FROM inspection_items WHERE inspection_id=? ORDER BY id"); $items->execute([$id]); $items=$items->fetchAll();
$files=$pdo->prepare("SELECT * FROM files WHERE inspection_id=?"); $files->execute([$id]); $files=$files->fetchAll();
$settings=$pdo->query("SELECT * FROM settings LIMIT 1")->fetch();
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>تقرير #<?=$ins['id']?></title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="./assets/app.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/html2canvas@1.4.1/dist/html2canvas.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/jspdf@2.5.1/dist/jspdf.umd.min.js"></script>
</head>
<body>
<?php include __DIR__.'/layout_nav.php'; ?>
<div class="container py-4">
  <div class="d-flex justify-content بين align-items-center mb-3">
    <h2 class="mb-0">تقرير فحص #<?=$ins['id']?></h2>
    <button class="btn btn-primary" id="btnPdf">تنزيل PDF</button>
  </div>

  <div id="reportArea" class="card shadow rounded-4">
    <div class="card-body">
      <div class="row g-3">
        <div class="col-md-8">
          <h5 class="mb-2">بيانات المركبة</h5>
          <div class="row g-2 small">
            <div class="col-md-4"><strong>لوحة:</strong> <?=e($ins['plate_number'])?></div>
            <div class="col-md-4"><strong>الشركة/الموديل:</strong> <?=e($ins['make'].' '.$ins['model'])?></div>
            <div class="col-md-4"><strong>السنة:</strong> <?=e($ins['year'])?></div>
            <div class="col-md-4"><strong>VIN:</strong> <?=e($ins['vin'])?></div>
            <div class="col-md-4"><strong>العداد:</strong> <?=e($ins['mileage'])?> كم</div>
            <div class="col-md-4"><strong>اللون:</strong> <?=e($ins['color'])?></div>
          </div>
        </div>
        <div class="col-md-4">
          <h5 class="mb-2">النتيجة العامة</h5>
          <div class="d-flex align-items-center gap-3">
            <div class="score-ring"><div class="ring" style="background: conic-gradient(var(--primary) 0% <?=$ins['overall_score']?>%, #e9ecef <?=$ins['overall_score']?>% 100%)"><span><?=$ins['overall_score']?>%</span></div></div>
            <div class="flex-grow-1">
              <div class="progress" style="height:12px"><div class="progress-bar <?=color_class((int)$ins['overall_score'])?>" style="width: <?=$ins['overall_score']?>%"></div></div>
              <div class="mt-1"><span class="badge <?=($ins['status']=='pass'?'text-bg-success':'text-bg-danger')?>"><?=($ins['status']=='pass'?'ناجح':'راسب')?></span></div>
              <div class="small text-muted mt-1">الفاحص: <?=e($ins['inspector'])?> — <?=e(date('Y-m-d H:i',strtotime($ins['inspected_at'])))?></div>
              <div class="small mt-1">
                <span class="badge text-bg-success badge-pill">جيدة: <?=$ins['good_count']?></span>
                <span class="badge text-bg-warning badge-pill">متوسطة: <?=$ins['fair_count']?></span>
                <span class="badge text-bg-danger badge-pill">سيئة: <?=$ins['poor_count']?></span>
                <span class="badge text-bg-secondary badge-pill">N/A: <?=$ins['na_count']?></span>
              </div>
            </div>
          </div>
        </div>
      </div>

      <hr>
      <h5 class="mb-2">تفاصيل النقاط</h5>
      <div class="row g-2">
        <?php foreach($items as $it):
          $badge='text-bg-secondary';
          if($it['result']==='good') $badge='text-bg-success';
          elseif($it['result']==='fair') $badge='text-bg-warning';
          elseif($it['result']==='poor') $badge='text-bg-danger';
        ?>
        <div class="col-md-6">
          <div class="border rounded-3 p-2">
            <div class="d-flex justify-content-between align-items-center">
              <strong><?=e($it['label'])?></strong>
              <span class="badge <?=$badge?>"><?=($it['result']=='good'?'جيدة':($it['result']=='fair'?'متوسطة':($it['result']=='poor'?'سيئة':'N/A')))?></span>
            </div>
            <?php if($it['remarks']): ?><div class="small text-muted mt-1"><?=e($it['remarks'])?></div><?php endif; ?>
            <div class="small text-muted mt-1">الوزن: <?=e($it['weight'])?></div>
          </div>
        </div>
        <?php endforeach; ?>
      </div>

      <?php if($ins['notes']): ?>
      <div class="mt-3"><h6>ملاحظات عامة</h6><p class="small"><?=nl2br(e($ins['notes']))?></p></div>
      <?php endif; ?>

      <?php if($files): ?>
      <hr><h5 class="mb-2">صور مرفقة</h5>
      <div class="row g-2">
        <?php foreach($files as $f): ?>
        <div class="col-6 col-md-3"><a href="../<?=$f['file_path']?>" target="_blank"><img class="img-fluid rounded-3 border" src="../<?=$f['file_path']?>" alt=""></a></div>
        <?php endforeach; ?>
      </div>
      <?php endif; ?>
    </div>
  </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
document.getElementById('btnPdf').addEventListener('click', async () => {
  const { jsPDF } = window.jspdf;
  const report=document.getElementById('reportArea');
  const canvas=await html2canvas(report,{scale:2});
  const img=canvas.toDataURL('image/png');
  const pdf=new jsPDF('p','mm','a4');
  const pw=pdf.internal.pageSize.getWidth(), ph=pdf.internal.pageSize.getHeight();
  const iw=pw-20, ih=canvas.height * iw / canvas.width;
  let left=canvas.height, pos=0, ratio=iw/canvas.width;
  if(ih <= ph-20){ pdf.addImage(img,'PNG',10,10,iw,ih); }
  else{
    const slice=document.createElement('canvas'); const pageH=(ph-20)/ratio;
    while(left>0){
      slice.width=canvas.width; slice.height=Math.min(pageH,left);
      slice.getContext('2d').drawImage(canvas,0,pos,canvas.width,slice.height,0,0,canvas.width,slice.height);
      pdf.addImage(slice.toDataURL('image/png'),'PNG',10,10,iw,slice.height*ratio);
      left-=slice.height; pos+=slice.height;
      if(left>0) pdf.addPage();
    }
  }
  pdf.save('inspection_<?=e($ins['plate_number'])?>_<?=e($ins['id'])?>.pdf');
});
</script>
</body>
</html>
