<?php
require_once __DIR__ . '/../lib/auth.php';
require_once __DIR__ . '/../lib/helpers.php';
require_login();
$pdo=db();
$q=trim($_GET['q']??'');
$where='';$params=[];
if($q!==''){ $where="WHERE c.plate_number LIKE ? OR c.vin LIKE ? OR c.model LIKE ?"; $like="%$q%"; $params=[$like,$like,$like]; }
$stmt=$pdo->prepare("SELECT i.id,i.overall_score,i.status,i.inspected_at,c.plate_number,c.model FROM inspections i JOIN cars c ON c.id=i.car_id $where ORDER BY i.inspected_at DESC LIMIT 300");
$stmt->execute($params); $rows=$stmt->fetchAll();
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>جميع التقارير</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="./assets/app.css" rel="stylesheet">
</head>
<body>
<?php include __DIR__.'/layout_nav.php'; ?>
<div class="container py-4">
  <form class="row g-2 mb-3" method="get">
    <div class="col-md-6"><input class="form-control" name="q" value="<?=e($q)?>" placeholder="بحث برقم اللوحة / الشاسيه / الموديل"></div>
    <div class="col-auto"><button class="btn btn-primary">بحث</button></div>
  </form>
  <div class="card shadow rounded-4">
    <div class="card-body">
      <div class="table-responsive">
        <table class="table align-middle">
          <thead><tr><th>التاريخ</th><th>اللوحة</th><th>الموديل</th><th>النتيجة</th><th>الحالة</th><th></th></tr></thead>
          <tbody>
          <?php foreach($rows as $r): ?>
            <tr>
              <td><?=e(date('Y-m-d H:i',strtotime($r['inspected_at'])))?></td>
              <td><?=e($r['plate_number'])?></td>
              <td><?=e($r['model'])?></td>
              <td><div class="progress" style="height:10px"><div class="progress-bar <?=color_class((int)$r['overall_score'])?>" style="width: <?=$r['overall_score']?>%"></div></div></td>
              <td><span class="badge <?=($r['status']=='pass'?'text-bg-success':'text-bg-danger')?>"><?=($r['status']=='pass'?'ناجح':'راسب')?></span></td>
              <td><a class="btn btn-sm btn-outline-primary" href="/public/inspection_view.php?id=<?=$r['id']?>">عرض</a></td>
            </tr>
          <?php endforeach; if(empty($rows)): ?><tr><td colspan="6" class="text-center text-muted">لا نتائج</td></tr><?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
</body>
</html>
