<?php
$pdo = db();
$st = $pdo->query("SELECT * FROM settings LIMIT 1")->fetch();
$brand = $st['company_name'] ?? 'Hazal Inspection';
$primary = $st['theme_primary'] ?? '#0d6efd';
$success = $st['theme_success'] ?? '#28a745';
$warning = $st['theme_warning'] ?? '#ffc107';
$danger  = $st['theme_danger']  ?? '#dc3545';
?>
<style>
:root{
  --primary: <?=$primary?>;
  --success: <?=$success?>;
  --warning: <?=$warning?>;
  --danger:  <?=$danger?>;
}
.btn-primary, .bg-primary { background-color: var(--primary)!important; border-color: var(--primary)!important; }
.text-primary { color: var(--primary)!important; }
.progress-bar.bg-success{ background-color: var(--success)!important; }
.progress-bar.bg-warning{ background-color: var(--warning)!important; }
.progress-bar.bg-danger{ background-color: var(--danger)!important; }
.badge.text-bg-success{ background-color: var(--success)!important; }
.badge.text-bg-warning{ background-color: var(--warning)!important; }
.badge.text-bg-danger{ background-color: var(--danger)!important; }
</style>
<nav class="navbar navbar-expand-lg bg-white border-bottom sticky-top">
  <div class="container">
    <a class="navbar-brand fw-bold" href="/public/dashboard.php"><?=$brand?></a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navb">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navb">
      <ul class="navbar-nav me-auto mb-2 mb-lg-0">
        <li class="nav-item"><a class="nav-link" href="/public/new_inspection.php">+ فحص جديد</a></li>
        <li class="nav-item"><a class="nav-link" href="/public/inspections.php">التقارير</a></li>
        <?php if(user() && user()['role']==='admin'): ?>
          <li class="nav-item"><a class="nav-link" href="/admin/index.php">لوحة المدير</a></li>
        <?php endif; ?>
      </ul>
      <div class="ms-auto">
        <span class="me-2 small text-muted"><?=e(user()['name']??'')?></span>
        <a class="btn btn-outline-danger btn-sm" href="/public/logout.php">خروج</a>
      </div>
    </div>
  </div>
</nav>
