<?php
require_once __DIR__ . '/../lib/auth.php';
require_once __DIR__ . '/../lib/helpers.php';
require_login();
$pdo=db();

// Fetch settings & checklist
$settings = $pdo->query("SELECT * FROM settings LIMIT 1")->fetch();
$groups = $pdo->query("SELECT * FROM checklist_groups ORDER BY sort_order, id")->fetchAll();
$itemsByGroup = [];
foreach($groups as $g){ $itemsByGroup[$g['id']] = []; }
$its = $pdo->query("SELECT * FROM checklist_items ORDER BY group_id, sort_order, id")->fetchAll();
foreach($its as $it){ $itemsByGroup[$it['group_id']][] = $it; }

$errors=[];
if($_SERVER['REQUEST_METHOD']==='POST'){
  csrf_check();
  // Car upsert
  $plate=trim($_POST['plate_number']??'');
  if($plate===''){ $errors[]='رقم اللوحة مطلوب'; }
  $make=trim($_POST['make']??'');
  $model=trim($_POST['model']??'');
  $year=(int)($_POST['year']??0);
  $vin=trim($_POST['vin']??'');
  $mileage=(int)($_POST['mileage']??0);
  $color=trim($_POST['color']??'');
  $notes=trim($_POST['notes']??'');

  if(empty($errors)){
    $pdo->beginTransaction();
    try{
      $car = $pdo->prepare("SELECT id FROM cars WHERE plate_number=?"); $car->execute([$plate]); $car=$car->fetch();
      if($car){ $car_id=(int)$car['id'];
        $pdo->prepare("UPDATE cars SET make=?,model=?,year=?,vin=?,mileage=?,color=? WHERE id=?")
            ->execute([$make,$model,$year?:null,$vin,$mileage?:null,$color,$car_id]);
      } else {
        $pdo->prepare("INSERT INTO cars(plate_number,make,model,year,vin,mileage,color) VALUES (?,?,?,?,?,?,?)")
            ->execute([$plate,$make,$model,$year?:null,$vin,$mileage?:null,$color]);
        $car_id=(int)db()->lastInsertId();
      }

      // Compute weighted score + counts
      $sumWeight=0;$sumEarned=0;$good=0;$fair=0;$poor=0;$na=0;
      $chosen=[];
      foreach($its as $it){
        $key='item_'.$it['item_key'];
        $val=$_POST[$key]??'na';
        if($val==='na'){ $na++; }
        else{
          $sumWeight += (float)$it['weight'];
          if($val==='good'){ $sumEarned += (float)$it['weight']; $good++; }
          elseif($val==='fair'){ $sumEarned += (float)$it['weight']*0.5; $fair++; }
          elseif($val==='poor'){ $poor++; }
        }
        $chosen[]=['key'=>$it['item_key'],'label'=>$it['label'],'weight'=>$it['weight'],'result'=>$val,'remarks'=>trim($_POST['remarks_'.$it['item_key']]??'')];
      }
      $score = $sumWeight>0 ? (int)round(($sumEarned/$sumWeight)*100) : 0;
      $status = ($score >= (int)$settings['pass_threshold']) ? 'pass' : 'fail';

      $pdo->prepare("INSERT INTO inspections(car_id,user_id,inspected_at,overall_score,good_count,fair_count,poor_count,na_count,status,notes)
                     VALUES (?,?,?,?,?,?,?,?,?,?)")
          ->execute([$car_id,user()['id'],date('Y-m-d H:i:s'),$score,$good,$fair,$poor,$na,$status,$notes]);
      $inspection_id=(int)$pdo->lastInsertId();

      $insItem = $pdo->prepare("INSERT INTO inspection_items(inspection_id,item_key,label,weight,result,remarks) VALUES (?,?,?,?,?,?)");
      foreach($chosen as $ch){
        $insItem->execute([$inspection_id,$ch['key'],$ch['label'],$ch['weight'],$ch['result'],$ch['remarks']]);
      }

      // Upload files
      if(!empty($_FILES['photos']['name']) && is_array($_FILES['photos']['name'])){
        $insFile = $pdo->prepare("INSERT INTO files(inspection_id,file_name,file_path,mime_type,size_kb) VALUES (?,?,?,?,?)");
        for($i=0;$i<count($_FILES['photos']['name']);$i++){
          if($_FILES['photos']['error'][$i]===UPLOAD_ERR_OK){
            $tmp=$_FILES['photos']['tmp_name'][$i];
            $name=basename($_FILES['photos']['name'][$i]);
            $ext=strtolower(pathinfo($name,PATHINFO_EXTENSION));
            if(in_array($ext,['jpg','jpeg','png','webp'])){
              $new=uniqid('img_').'.'.$ext; $dest=UPLOAD_DIR.'/'.$new;
              if(move_uploaded_file($tmp,$dest)){
                $mime=@mime_content_type($dest)?:null; $size=intval(filesize($dest)/1024);
                $insFile->execute([$inspection_id,$new,'storage/uploads/'.$new,$mime,$size]);
              }
            }
          }
        }
      }

      $pdo->commit();
      header('Location: /public/inspection_view.php?id='.$inspection_id); exit;
    } catch(Exception $ex){
      $pdo->rollBack();
      $errors[]='خطأ أثناء الحفظ: '.$ex->getMessage();
    }
  }
}
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>فحص جديد</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="./assets/app.css" rel="stylesheet">
</head>
<body>
<?php include __DIR__.'/layout_nav.php'; ?>
<div class="container py-4">
  <h2 class="mb-3">إنشاء تقرير فحص</h2>

  <?php if($errors): ?><div class="alert alert-danger"><ul class="mb-0"><?php foreach($errors as $e) echo '<li>'.e($e).'</li>'; ?></ul></div><?php endif; ?>

  <!-- Score header -->
  <div class="card shadow rounded-4 mb-3">
    <div class="card-body d-flex align-items-center gap-3">
      <div class="score-ring">
        <div class="ring"><span id="scoreText">0%</span></div>
      </div>
      <div class="flex-grow-1">
        <div class="progress" style="height:16px"><div id="scoreBar" class="progress-bar" style="width:0%"></div></div>
        <div class="small text-muted mt-1">يعتمد على وزن كل عنصر (جيد 100%، متوسط 50%) — عتبة النجاح: <?=$settings['pass_threshold']?>%</div>
        <div class="small mt-1">
          <span class="badge text-bg-success badge-pill">جيدة: <span id="countGood">0</span></span>
          <span class="badge text-bg-warning badge-pill">متوسطة: <span id="countFair">0</span></span>
          <span class="badge text-bg-danger badge-pill">سيئة: <span id="countPoor">0</span></span>
          <span class="badge text-bg-secondary badge-pill">N/A: <span id="countNA">0</span></span>
        </div>
      </div>
    </div>
  </div>

  <form method="post" enctype="multipart/form-data" class="vstack gap-3">
    <input type="hidden" name="csrf" value="<?=e(csrf_token())?>">

    <div class="card rounded-4 shadow border-0">
      <div class="card-body row g-3">
        <div class="col-md-3"><label class="form-label">رقم اللوحة</label><input name="plate_number" class="form-control" required></div>
        <div class="col-md-3"><label class="form-label">الشركة</label><input name="make" class="form-control"></div>
        <div class="col-md-3"><label class="form-label">الموديل</label><input name="model" class="form-control"></div>
        <div class="col-md-3"><label class="form-label">سنة الصنع</label><input name="year" type="number" class="form-control"></div>
        <div class="col-md-4"><label class="form-label">VIN</label><input name="vin" class="form-control"></div>
        <div class="col-md-4"><label class="form-label">العداد (كم)</label><input name="mileage" type="number" class="form-control"></div>
        <div class="col-md-4"><label class="form-label">اللون</label><input name="color" class="form-control"></div>
      </div>
    </div>

    <?php foreach($groups as $g): $gitems=$itemsByGroup[$g['id']]??[]; if(!$gitems) continue; ?>
    <div class="card rounded-4 shadow border-0">
      <div class="card-body">
        <h5 class="mb-3"><?=e($g['name'])?></h5>
        <div class="row g-3">
          <?php foreach($gitems as $it): ?>
          <div class="col-md-6">
            <div class="check-item p-3">
              <div class="d-flex justify-content-between align-items-center mb-2">
                <strong><?=e($it['label'])?></strong>
                <span class="badge bg-secondary">وزن: <?=e($it['weight'])?></span>
              </div>
              <div class="btn-group" role="group" aria-label="<?=e($it['label'])?>">
                <input type="radio" class="btn-check score-radio" name="item_<?=e($it['item_key'])?>" id="<?=e($it['item_key'])?>_g" value="good" data-weight="<?=e($it['weight'])?>">
                <label class="btn btn-outline-success btn-sm" for="<?=e($it['item_key'])?>_g">جيدة</label>

                <input type="radio" class="btn-check score-radio" name="item_<?=e($it['item_key'])?>" id="<?=e($it['item_key'])?>_f" value="fair" data-weight="<?=e($it['weight'])?>">
                <label class="btn btn-outline-warning btn-sm" for="<?=e($it['item_key'])?>_f">متوسطة</label>

                <input type="radio" class="btn-check score-radio" name="item_<?=e($it['item_key'])?>" id="<?=e($it['item_key'])?>_p" value="poor" data-weight="<?=e($it['weight'])?>">
                <label class="btn btn-outline-danger btn-sm" for="<?=e($it['item_key'])?>_p">سيئة</label>

                <input type="radio" class="btn-check score-radio" name="item_<?=e($it['item_key'])?>" id="<?=e($it['item_key'])?>_n" value="na" data-weight="<?=e($it['weight'])?>" checked>
                <label class="btn btn-outline-secondary btn-sm" for="<?=e($it['item_key'])?>_n">N/A</label>
              </div>
              <input class="form-control form-control-sm mt-2" name="remarks_<?=e($it['item_key'])?>" placeholder="ملاحظة (اختياري)">
            </div>
          </div>
          <?php endforeach; ?>
        </div>
      </div>
    </div>
    <?php endforeach; ?>

    <div class="card rounded-4 shadow border-0">
      <div class="card-body">
        <label class="form-label">صور مرفقة (متعدد)</label>
        <input type="file" class="form-control" name="photos[]" multiple accept=".jpg,.jpeg,.png,.webp">
      </div>
    </div>

    <div class="card rounded-4 shadow border-0">
      <div class="card-body">
        <label class="form-label">ملاحظات عامة</label>
        <textarea class="form-control" name="notes" rows="3"></textarea>
      </div>
    </div>

    <div class="d-flex gap-2">
      <button class="btn btn-primary btn-lg">حفظ التقرير</button>
      <a class="btn btn-outline-secondary btn-lg" href="/public/dashboard.php">إلغاء</a>
    </div>
  </form>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="/public/assets/app.js"></script>
</body>
</html>
